import nanotec.*;
/*Mit diesem Programm ist es auch im Drehzahl-, Analog- und Joystickmodus möglich einen (mehrere) Endschalter zu verwenden und dadurch den Motor zu stoppen.
  Im Programm wird bei Überfahren des Schalters die Position gespeichert, dann gestoppt und dann entsprechend + oder - 30 Schritte zur gespeicherten Position verfahren (frei rückwärts).
  Nach der Freifahrt ist die Steuerung wieder betriebsbereit. Für den Referenzschalter kann jeder der 6 Eingänge verwendet werden.
  Dieser muss mit Nanopro; Reiter „Eingänge“ als „Externer Referenzschalter“ konfiguriert werden. 
  
  
  With this program it is possible to use one (several) limit switches to stop the motor in speed- analog- or joystick mode.
  At the moment the switch is reached, the position will be saved and the motor stops. Now the motor moves to the saved position + or - 30 steps (free reverse).
  After this procedure the controller is ready for operation again. Each of the six inputs can be used as reference switch.
  This input must be configured with Nanopro on the tab "Input" as "external reference swich".  
  */

class Endschalter_Drehzahlmodus
{	
	public static void main() 
	{
		
		util.Sleep(100);						//Wartezeit in ms, waiting time in ms
		int x1 = io.GetInput1Selection();		//auslesen der Funktion des Digitaleinganges 1, reading the function of input 1
		int x2 = io.GetInput2Selection();		//auslesen der Funktion des Digitaleinganges 2, reading the function of input 2
		int x3 = io.GetInput3Selection();		//auslesen der Funktion des Digitaleinganges 3, reading the function of input 3
		int x4 = io.GetInput4Selection();		//auslesen der Funktion des Digitaleinganges 4, reading the function of input 4
		int x5 = io.GetInput5Selection();		//auslesen der Funktion des Digitaleinganges 5, reading the function of input 5
		int x6 = io.GetInput6Selection();		//auslesen der Funktion des Digitaleinganges 6, reading the function of input 6
		
		while(true)
		{
			while(drive.GetMode()==5||drive.GetMode()==11||drive.GetMode()==12) //Modusabfrage Drehzahl, Analog oder Joystick, reading operation mode only speed, analog or joystick
			{
				if((x1==7 && util.TestBit(io.GetDigitalInput(),0))||			//wenn Funktion ext. Referenzschalter gewählt und Eingang high
				   (x2==7 && util.TestBit(io.GetDigitalInput(),1))||			//if function ext. referenceswitch is used and Input is high
				   (x3==7 && util.TestBit(io.GetDigitalInput(),2))||			//alle 6 Eingänge werden überprüft, all 6 inputs are checked
				   (x4==7 && util.TestBit(io.GetDigitalInput(),3))||			//alle 6 Eingänge werden überprüft, all 6 inputs are checked
				   (x5==7 && util.TestBit(io.GetDigitalInput(),4))||			//alle 6 Eingänge werden überprüft, all 6 inputs are checked
				   (x6==7 && util.TestBit(io.GetDigitalInput(),5)))				//alle 6 Eingänge werden überprüft, all 6 inputs are checked
				{
					int y = drive.GetDemandPosition();	//schreibt die aktuelle Position in die Variable y, writes the actual positioning into the variable y
					drive.StopDrive(1);					//stoppt die Fahrt mit normaler Bremsrampe, stopping the actual drive with normal brake ramp
					util.Sleep(100);					//Wartezeit für Stop, waiting time for stop
					drive.SetMode(2);					//setzt absolute Positionierung, setting mode absolute positioning
					drive.SetMaxSpeed(100);				//Maximalgeschwindigkeit auf 100Hz gesetzt, setting max. speed to 100Hz
					
					if(drive.GetDemandPosition()<y) 	//Wenn die Position nach dem Stop <y ist, if position after stop is <y
					{
						drive.SetTargetPos(y+30);		//setzte Zielposition y+30 Schritte, set target position y+30 steps
						drive.StartDrive();				//starte die absolute Positionierung, start absolut positioning
					}
					
					if(drive.GetDemandPosition()>y) 	//Wenn die Position nach dem Stop >y ist, if position after stop is >y
					{
						drive.SetTargetPos(y-30);		//setzte Zielposition y-30 Schritte, set target position y-30 steps
						drive.StartDrive();				//starte die absolute Positionierung, start absolut positioning
					}
				}
			}
		}			
	}
}	