# Nanolib

This is the C++ Version of the Nanolib. The NanoLib offers an easy to use library to control Nanotec devices

www.nanotec.de

## Windows
### Example Project
#### Prerequisites
- Install Microsoft Visual Studio 2022
- Install HMS, IXXAT VCI 4 driver and connect CAN adapter.
- Connect all devices to the CAN adapter according to the user manual and power on the devices.

#### Compiling and running the example project
- Open the file ```NanolibExample.sln``` (below example\NanolibExample) with Visual Studio. The main file for the example is ```nanolib_example_program.cpp```.
- Wait some seconds until the loading of the project is complete.
- Adjust the example to your needs: NodeId, Baudrate etc.
- Compile and run the example code.
  
### Compiling and running the nanolib in your own project
#### Prerequisites
- Unpack all files and folders of the nanolib_cpp_win_#.#.#.zip file.
- Create a folder for your local project - Example: ```C:\LocalProject```

#### Create new project
- Open Visual Studio 2022, on the welcome screen click on "Create new project".
- You can now choose the type of the project. Choose "Console App - C++, click next.
- You now need to give the project a name (e.g. "NanolibTest") and set its location to your local project folder.
- Click on "Create"
- Select a configuration Release, 64-bit
- Copy the folders ```lib``` and ```inc``` from the nanolib_cpp_win_#.#.#.zip file into your local project folder. 
- Open the settings of the project
   1. In the compiler settings
      1. add the ```inc``` path to the "Additional Include Paths"
      2. and set the "C++ Language Standard" (under "Language") to "ISO C++17 (/std:c++17)"
   2. In the linker settings
     1. add the ```lib``` path of the dlls to "Additional Library Directories"
	 2. add the file "nanolib.lib" to the "Additional Dependencies"
- Copy the following code into the main file and save it:
```C++
#include "accessor_factory.hpp"
#include <iostream>

int main()
{
	// DO NOT TRY TO delete THIS POINTER!
	nlc::NanoLibAccessor* nanolibAccessor = getNanoLibAccessor();
	nlc::ResultBusHwIds result = nanolibAccessor->listAvailableBusHardware();

	if (result.hasError())
	{
		std::cerr << "listAvailableBusHardware failed with error: " <<
			static_cast<int>(result.getErrorCode()) << " " << result.getError() << std::endl;
	}
	else
	{
		auto busHardwareIds(result.getResult());

		std::cout << "Available hardware buses and protocols:" << std::endl;

		for (const auto& busHardwareId : busHardwareIds)
		{
			std::cout << busHardwareId.getName()
				<< " protocol: " << busHardwareId.getProtocol() << std::endl;
		}
	}

	return 0;
}

```
- Compile everything
 In the compile output window, there should be no error but something like
```
========== Build: 1 succeeded, 0 failed, 0 up-to-date, 0 skipped ==========
```
- Before running the executable, copy the file ```nanolib.dll``` and all ```nanolibm_*.dll``` files to the same folder of the executable.
- Upon successful execution, the application will display a list of available hardware buses and communication protocols


## Linux
### Example Project
- Install HMS, Ixxat ECI driver and connect CAN adapter.
- Connect all devices to the CAN adapter according to the user manual and power on the devices.
  
#### Compiling and running the example project
- Open a command prompt (e.g. bash) and change to extracted nanolib example directory. The main file for the example is ```src/nanolib_example_program.cpp```.
- Build the example
```bash
  make all
```
- Install the example
 ```bash
  make install
``` 
> **_Note:_** The following command from the make script will require sudo privileges:  ```sudo setcap cap_net_raw,cap_net_admin=eip $(OUT_PATH)example``` \
> It is necessary to allow Modbus TCP bus scanning. See: https://linux.die.net/man/7/capabilities

- Execute the example
```bash
  ./bin/example
```

- Uninstall the Library if needed
```bash
  sudo make uninstall
```