///
/// Nanotec Nanolib example
/// Copyright (C) Nanotec GmbH & Co. KG - All Rights Reserved
///
/// This product includes software developed by the
/// Nanotec GmbH & Co. KG (http://www.nanotec.com/).
///
/// The Nanolib interface headers and the examples source code provided are 
/// licensed under the Creative Commons Attribution 4.0 Internaltional License. 
/// To view a copy of this license, 
/// visit https://creativecommons.org/licenses/by/4.0/ or send a letter to 
/// Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
///
/// The parts of the library provided in binary format are licensed under 
/// the Creative Commons Attribution-NoDerivatives 4.0 International License. 
/// To view a copy of this license, 
/// visit http://creativecommons.org/licenses/by-nd/4.0/ or send a letter to 
/// Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
///
/// This program is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
///
/// <file_name>ScanBusCallbackExample.cs</file_name>
///
/// <summary>Definition of scan bus callback class</summary>
///
/// <date>29-10-2024</date>
///
/// <author>Michael Milbradt<author>
///

using Nlc;

namespace NanolibExample
{
    /// <summary>
    /// Implementation class for NlcScanBusCallback, handling the scan bus callback.
    /// </summary>
    public class ScanBusCallbackExample : NlcScanBusCallback
    {
        /// <summary>
        /// Gets called during bus scan.
        /// </summary>
        /// <param name="info">State of data scan.</param>
        /// <param name="devicesFound">List of DeviceId, containing already found devices.</param>
        /// <param name="data">Progress of scan (if known).</param>
        /// <returns>ResultVoid with error if an error occurred.</returns>
        public override ResultVoid callback(BusScanInfo info, DeviceIdVector devicesFound, int data)
        {
            // Suppress the unused variable warning
            _ = devicesFound;

            switch (info)
            {
                case BusScanInfo.Start:
                    Console.WriteLine("Scan started.");
                    break;

                case BusScanInfo.Progress:
                    // data holds scan progress
                    if ((data & 1) == 0)
                    {
                        Console.Write(".");
                    }
                    break;

                case BusScanInfo.Finished:
                    Console.WriteLine("\nScan finished.");
                    break;

                default:
                    break;
            }

            return new ResultVoid();
        }
    }
}

