
package com.nanotec.example.nanolibexample;

import java.util.Iterator;
import com.nanotec.nanolib.BusHardwareId;
import com.nanotec.nanolib.ProfinetDCP;
import com.nanotec.nanolib.ProfinetDeviceVector;
import com.nanotec.nanolib.ProfinetDevice;
import com.nanotec.nanolib.ResultVoid;
import com.nanotec.nanolib.ResultProfinetDevices;
import com.nanotec.nanolib.NlcErrorCode;

public class NanolibProfinetExample {
    private BusHardwareId busHwId;
    private ProfinetDCP profinetDcpInterface;

    public void setup(BusHardwareId busHwId, ProfinetDCP profinetDcpInterface) {
        this.busHwId = busHwId;
        this.profinetDcpInterface = profinetDcpInterface;
    }

    public void execute() {
        System.out.println(("NanolibProfinetExample: Executing ...."));

        System.out.println("Scanning " + this.busHwId.getName() +  " for Profinet devices...");
	    ResultProfinetDevices resultProfinetDevices	= this.profinetDcpInterface.scanProfinetDevices(this.busHwId);

	    if (resultProfinetDevices.hasError() && (resultProfinetDevices.getErrorCode() != NlcErrorCode.TimeoutError)) {
		    System.out.println("ProfinetDCP::scanProfinetDevices failed with error: " + resultProfinetDevices.getError());
		    return;
	    }

	    ProfinetDeviceVector profinetDevices = resultProfinetDevices.getResult();
	    int numberOfProfinetDevices = profinetDevices.size();

	    if (numberOfProfinetDevices < 1) {
		    System.out.println("No Profinet devices found.");
		    return;
	    }

	    System.out.println(numberOfProfinetDevices + " Profinet device(s) found:");
	    for (Iterator<ProfinetDevice> pd = profinetDevices.iterator(); pd.hasNext();) {
            ProfinetDevice profinetDevice = pd.next();
            long ipAddress1 = (profinetDevice.getIpAddress() >> 24) & 0x000000FF;
            long ipAddress2 = (profinetDevice.getIpAddress() >> 16) & 0x000000FF;
            long ipAddress3 = (profinetDevice.getIpAddress() >> 8) & 0x000000FF;
            long ipAddress4 = profinetDevice.getIpAddress() & 0x000000FF;
		    System.out.println("IP: " + String.valueOf(ipAddress1) + "." +  
                String.valueOf(ipAddress2) + "." +  String.valueOf(ipAddress3) + "." + 
                String.valueOf(ipAddress4) + "\tName: " + profinetDevice.getDeviceName());

		    // Checking the IP address against the context of the current network configuration
		    ResultVoid resultValid = this.profinetDcpInterface.validateProfinetDeviceIp(this.busHwId, profinetDevice);
		    System.out.println("\tDevice IP is " + (resultValid.hasError() ? " not " : "") + 
            "valid into current network.");

            // Trying to blink the device
            ResultVoid resultBlink = this.profinetDcpInterface.blinkProfinetDevice(this.busHwId, profinetDevice);
            System.out.println("\tBlink the device ");
            if (resultBlink.hasError())
                System.out.println("failed with error: " + resultBlink.getError());
            else
                System.out.println("succeeded.");
	    }
    }
}