/**
* Nanotec Nanolib example
* Copyright (C) Nanotec GmbH & Co. KG - All Rights Reserved
*
* This product includes software developed by the
* Nanotec GmbH & Co. KG (http://www.nanotec.com/).
*
* The Nanolib interface headers and the examples source code provided are 
* licensed under the Creative Commons Attribution 4.0 Internaltional License. 
* To view a copy of this license, 
* visit https://creativecommons.org/licenses/by/4.0/ or send a letter to 
* Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
*
* The parts of the library provided in binary format are licensed under 
* the Creative Commons Attribution-NoDerivatives 4.0 International License. 
* To view a copy of this license, 
* visit http://creativecommons.org/licenses/by-nd/4.0/ or send a letter to 
* Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
*
* @file   ScanBusCallbackExample.java
*
* @brief  Definition of scan bus callback class
*
* @date   29-10-2024
*
* @author Michael Milbradt
*
*/
package com.nanotec.example.NanolibExample;

import com.nanotec.nanolib.ResultVoid;
import com.nanotec.nanolib.BusScanInfo;
import com.nanotec.nanolib.DeviceIdVector;
import com.nanotec.nanolib.NlcScanBusCallback;

/**
* Implementation class of NlcScanBusCallback, handling the bus scan callback
*/
public class ScanBusCallbackExample extends NlcScanBusCallback {

	/**
    * @brief Gets called during bus scan
    *
    * @param  info state of data transfer
	* @param  devicesFound vector of DeviceId for already found devices
    * @param  data progress of data transfer (0-100)
    * @return ResultVoid with error if error occured
    */
    @Override
    public ResultVoid callback(BusScanInfo info, DeviceIdVector devicesFound, int data) {
		if (BusScanInfo.Start == info) {
			System.out.println("Scan started.");
		} else if (BusScanInfo.Progress == info) {
			if ((data & 1) == 0) // data holds scan progress
			{
				System.out.print(".");
			}
		} else if (BusScanInfo.Finished == info) {
			System.out.println("");
			System.out.println("Scan finished.");
		}

		return new ResultVoid();
	}
}
