# Nanolib

This is the Java version of NanoLib with an example application. <br>
The NanoLib offers an easy to use library to control Nanotec devices.

[www.nanotec.de](https://www.nanotec.de/)

## Example Application
### Overview and Structure
The CLI example application provides a menu interface where the user can execute
the different library functions. The menu offers the user the possibility to <br>
easily and quickly select and execute all functions supported by NanoLib. <br>
The menu entries are context based and will be enabled or disabled, depending on
the state.<br>
To enable all entries you have to:
1. Scan for hardware buses
2. Connect to a found harwdare bus
3. Scan for devices on the opened hardware bus
4. Successfully connect to a found device<br>
 
With this example application it is possible to:<br> 
- do a hardware bus scan
- open a found bus hardware (several hardware buses allowed)
- close an opened bus hardware
- scan for devices on opened hardware bus(es)
- connect to a found device (several devices allowed)
- disconnect from a connected device 
- read device informations
- update the firmware
- update the bootloader
- upload a NanoJ program
- run/stop a NanoJ program
- reboot a device
- set logging and logging callback parameters
- auto tune a motor (may require manual steps before)
- get a motor to rotate
- use the object dicationary interface for reads/writes
- sample data
- scan for Profinet devices
- etc.

The application menu and the supported NanoLib functionality is logically structered into several files:<br>
Files with \*FunctionsExample.java contain the implementations for the NanoLib interface functions.<br>
Files with \*CallbackExample.java contain implementations for the various callbacks (scan, data and logging).<br>
Files with Menu\*.java contain the menu logic and code.<br>
Example.java is the main program, creating the menu and initializing all used parameters.<br>
SamplerExample.java contains the example implementation for sampler usage.<br>

### Prerequisites
- A JRE or JDK 11 64 bit (or higher) installation is required.
- For Windows: Install [HMS - Ixxat VCI 4 driver](https://hmsnetworks.blob.core.windows.net/nlw/docs/default-source/products/ixxat/monitored/pc-interface-cards/vci-v4-0-1240-windows-11-10.zip?sfvrsn=2d1dfdd7_69) and connect CAN adapter (optional).
- For Linux: Install [HMS Ixxat ECI driver](https://hmsnetworks.blob.core.windows.net/nlw/docs/default-source/products/ixxat/monitored/pc-interface-cards/eci-linux.zip?sfvrsn=19eb48d7_53) and connect CAN adapter (optional).
- For Windows: Install [PEAK device driver and PCAN API](https://www.peak-system.com/quick/DrvSetup) and connect CAN adapter (optional).
- For Linux: Download, build and install [PEAK device driver for linux and PCAN API](https://www.peak-system.com/quick/PCAN-Linux-Driver) and connect CAN adapter (optional).
- Connect all devices to your adapter(s) according to the user manual and power on the devices.

### Running the example application
- Open a command prompt (e.g. powershell, cmd or bash)
- Change to the example directory within the extracted contents of the NanoLib Zip-file
   ```cmd
   cd <nanolib directory>\example
  ```
- Start the java example program
   ```cmd
   java -jar nanolib-NanolibExample-N.N.N.jar
  ```
  
**_Note:_** Where `N` is the actual version number of the nanolib.
