﻿function createNanoJEditor(theme) {
    globalThis.consoleMessages = [];
    globalThis.consoleDecorations = [];
    globalThis.consoleDecorations = [];
    globalThis.consoleMessages = [];

    globalThis.monacoEditor = monaco.editor.create(document.getElementById('container'), {
        theme: 'vs-'+theme,
        model: null,
        language: 'c',
        name: 'monacoEditor',
        showUnused: true,
        automaticLayout: true
    });
    globalThis.monacoTabs = new Object();
    globalThis.monacoTabStates = new Object();
    let model = monaco.editor.createModel("// Select NanoJ", "c");
    globalThis.monacoTabs[""] = model;
    globalThis.monacoEditor.setModel(model);

    globalThis.currentMonacoTab = model;
    globalThis.currentMonacoLocation = "";

    globalThis.consoleEditor = monaco.editor.create(document.getElementById('console'), {
        theme: 'vs-' + theme,
        model: null,
        language: 'log',
        lineNumbers: "off",
        name: 'consoleEditor',
        wordWrap: "on",
        minimap: { enabled: false },
        scrollBeyondLastLine: false,
        automaticLayout: true,
        readOnly: true
        
    });

    // Define the model for the NanoJ console without any messages
    globalThis.consoleModel = monaco.editor.createModel("", "log");
    globalThis.consoleEditor.setModel(globalThis.consoleModel);

    // Execute the C# method 'OnWebMessageReceived()' in '.\mvvm\nanotec.pnds.view\modules\nanoj\codeeditor\CodeEditorView.xaml.cs'
    window.chrome.webview.postMessage("##LOADED");
}
function changeTheme(theme) {
    console.log("change theme", theme);

    switch (theme) {
        case 'light':
            globalThis.monacoEditor.updateOptions({ theme: "vs-light" });
            break;

        case 'dark':
            globalThis.monacoEditor.updateOptions({ theme: "vs-dark" });
            break;

    }
}
function setTabText(text, location, language = "c") {
    console.log("setTabText ", text, location, language);

    let model;
    if (!globalThis.monacoTabs.hasOwnProperty(location)) {
        model = monaco.editor.createModel(text, language);
        model.onDidChangeContent((event) => {
            window.chrome.webview.postMessage(globalThis.monacoEditor.getValue());
        });
        globalThis.monacoTabs[location] = model;

    } else {
        model = globalThis.monacoTabs[location];
    }
    if (model !== globalThis.currentMonacoTab) {
        if (globalThis.currentMonacoLocation !== null) {
            // save current tab state
            let currentState = monacoEditor.saveViewState();
            globalThis.monacoTabStates[currentMonacoLocation] = currentState;

        }
        // set model
        globalThis.monacoEditor.setModel(model);
        globalThis.currentMonacoTab = model;
        globalThis.currentMonacoLocation = location;



        //  restore state if present
        if (globalThis.monacoTabStates.hasOwnProperty(location)) {
            globalThis.monacoEditor.restoreViewState(globalThis.monacoTabStates[location].state);
        }
        // else if new text
        else if (text !== null) {
            globalThis.monacoEditor.getModel().setValue(text);
        }
    }
    
}
function resizeDocument(width, height){
    document.body.style.width = width +'px'
    document.body.style.height = height+ 'px'
}
function closeAllTabs() {
    // Dispose all models except the default one
    for (let key in globalThis.monacoTabs) {
        if (globalThis.monacoTabs.hasOwnProperty(key)) {
            let model = globalThis.monacoTabs[key];
            if (model && typeof model.dispose === "function") {
                model.dispose();
            }
        }
    }
    // Clear tab and state objects
    globalThis.monacoTabs = {};
    globalThis.monacoTabStates = {};

    // Create and set a new default model
    let defaultModel = monaco.editor.createModel("// Select NanoJ", "c");
    globalThis.monacoTabs[""] = defaultModel;
    globalThis.monacoEditor.setModel(defaultModel);

    globalThis.currentMonacoTab = defaultModel;
    globalThis.currentMonacoLocation = "";
}
function addMarkerToTab(location, lineNumber, message, messageType = "error") {
    let severity = monaco.MarkerSeverity.Error;
    switch (messageType) {
        case "warning":
            severity = monaco.MarkerSeverity.Warning;
            break;
    }
    const model = globalThis.monacoTabs[location];
    if (!model) {
        console.warn(`No tab found for location: ${location}`);
        return;
    }
    if (lineNumber < 1 || lineNumber > model.getLineCount()) {
        console.warn(`Invalid line number: ${lineNumber}`);
        return;
    }
    const owner = location || "owner";
    const markers = [{
        startLineNumber: lineNumber,
        startColumn: 1,
        endLineNumber: lineNumber,
        endColumn: model.getLineMaxColumn(lineNumber),
        message: message,
        severity: severity,
    }];
    monaco.editor.setModelMarkers(model, owner, markers);
}
function clearAllMarkers() {
    for (let location in globalThis.monacoTabs) {
        if (globalThis.monacoTabs.hasOwnProperty(location)) {
            const model = globalThis.monacoTabs[location];
            if (model && typeof model.getLineCount === "function") {
                // Use the same owner as in addMarkerToTab
                monaco.editor.setModelMarkers(model, location || "owner", []);
            }
        }
    }
}
function clearConsole() {
    // First clear visible messages
    globalThis.consoleModel.setValue("");
    // Then clear stored data
    globalThis.consoleDecorations = [];
    globalThis.consoleMessages = [];
}
function scrollConsoleToBottom() {
    const lineCount = globalThis.consoleModel.getLineCount();
    if (lineCount > 0) {
        globalThis.consoleEditor.revealLine(lineCount);
    }
}

function addMessageToConsole(messageText, messageType = "info") {
    // First validate the new message for the user
    if (typeof messageText === 'string' || messageText instanceof String) {
        // After that display it as a new line
        let finalValue = "";
        let previousValue = globalThis.consoleModel.getValue();
        if(previousValue != "") {
            finalValue = previousValue + globalThis.consoleModel.getEOL() +  "> " + messageText;
        } else {
            finalValue = "> " + messageText;
        }
        globalThis.consoleModel.setValue(finalValue);
        // Add the new message in a global array
        globalThis.consoleMessages.push(messageText);

        // After that validate the message type
        if (typeof messageType === 'string' || messageType instanceof String) {
            // According to the message type, set the CSS classes for the decoration
            let decorationClass = "";
            let inlineClass = "";
            switch (messageType) {
                case "error":
                    decorationClass = "errorDecoration";
                    inlineClass = "errorTextDecoration";
                    break;
                case "warning":
                    decorationClass = "warningDecoration";
                    inlineClass = "warningTextDecoration";
                    break;
                // Empty string should display message as default
                // Skip CSS style "info"
            }

            // Count visible lines in order to target the last one
            const lineCount = globalThis.consoleModel.getLineCount();

            // Add the new message decoration in a global array
            globalThis.consoleDecorations.push({
                range: new monaco.Range(lineCount, 1, lineCount, 1),
                options: {
                    isWholeLine: true,
                    linesDecorationsClassName: decorationClass,
                    inlineClassName: inlineClass
                }
            });

            // Update decorations of all messages
            globalThis.consoleEditor.deltaDecorations(
                [],
                globalThis.consoleDecorations
            );
            // This could be slow if there are a lot of messages
            scrollConsoleToBottom();
        }
    }
}
function displayCollectionToConsole(messageTextArray, messageTypeArray) {
    if (Array.isArray(messageTextArray)) {
        clearConsole();
        if (Array.isArray(messageTypeArray)) {
            if(messageTextArray.length == messageTypeArray.length)
            {
                for (let i = 0; i < messageTextArray.length; i++) {
                    addMessageToConsole(messageTextArray[i], messageTypeArray[i]);
                }
            }
            else {
                for (let i = 0; i < messageTextArray.length; i++) {
                    addMessageToConsole(messageTextArray[i]);
                }
            }
        }
        else {
            for (let i = 0; i < messageTextArray.length; i++) {
                addMessageToConsole(messageTextArray[i]);
            }
        }
        scrollConsoleToBottom();
    }
}
